$assemblyFile = Get-Location
$assemblyFile = $assemblyFile.Path + '\inetsoftware.Pdfc.dll';
$assembly = [System.Reflection.Assembly]::LoadFrom($assemblyFile);


try
{
    $pdf1 = $PSScriptRoot +'\..\resources\Example1.pdf';
    $pdf2 = $PSScriptRoot + '\..\resources\Example2.pdf';
    $pdfc = New-Object inetsoftware.Pdfc.PDFComparer;
    #$presenter = New-Object inetsoftware.Pdfc.Presenter.ConsolePresenter;
    $root = (Get-Location).Path;
    $presenter = New-Object inetsoftware.Pdfc.Presenter.DifferencesPDFPresenter( $root );
    #$presenter = New-Object inetsoftware.Pdfc.Presenter.ReportPDFPresenter( 0, 0, $root.Path );
    $result = $pdfc.AddPresenter( $presenter ).Compare( $pdf1, $pdf2 );
    Write-Host 'Differences: ' $result.GetDifferencesCount( 0 );
    Write-Host 'Target path: ' $root;
}
catch
{
    $PSItem.Exception.ToString()
}

Write-Host -NoNewLine 'Press any key to continue...';
$null = $Host.UI.RawUI.ReadKey('NoEcho,IncludeKeyDown');